/*
** INI(INF) file treating module
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 7/3 coding start
*/

#include <stdio.h>
#include <stdlib.h>

#define INI_C
#include "ini.h"

int open_ini_file(char *path, INI *out);
int close_ini_file(INI *p);
char *get_ini_element_value(INI *p, char *section, char *key);
char *read_ini_element_value(INI *p, char *section, char *key);

static int is_blank(char *line);
static int new_section(char *line, INI *p);
static int new_element(char *line, INI_SECTION *p);

static INI_SECTION *find_ini_section(INI *p, char *section);
static INI_ELEMENT *find_ini_element(INI_SECTION *p, char *key);

/*******************************************************************
  function spec should be writen here
 *******************************************************************/
int open_ini_file(char *path, INI *out)
{
	FILE *in;
	char *line;
	const int line_max = 512;

	out->path = path;

	in = fopen(path, "rt");
	if(in == NULL){
		return 0;
	}

	line = (char *)malloc(line_max);

	while(fgets(line, line_max-1, in)){
		if(is_blank(line)){
			continue;
		}
		if(line[0] == '['){
			new_section(line, out);
		}else if(out->num_of_sections){
			new_element(line, out->sections + out->num_of_sections - 1);
		}else{
			close_ini_file(out);
			fclose(in);
			free(line);
			return 0;
		}
	}

	fclose(in);
	free(line);
	return 1;
}

/*******************************************************************
  function spec should be writen here
 *******************************************************************/
int close_ini_file(INI *p)
{
	int i,j;

	for(i=0;i<p->num_of_sections;i++){
		for(j=0;j<p->sections[i].num_of_elements;j++){
			free(p->sections[i].elements[j].key);
			free(p->sections[i].elements[j].value);
		}
		free(p->sections[i].elements);
        free(p->sections[i].label);
	}
	free(p->sections);

	return 1;
}

/*******************************************************************
  function spec should be writen here
 *******************************************************************/
char * get_ini_element_value(INI *p, char *section, char *key)
{
	int n;
	char *r;
	char *w;

	w = read_ini_element_value(p, section, key);

	n = strlen(w)+1;
	r = (char *)malloc(n);
	memcpy(r, w, n);

	return r;
}

/*******************************************************************
  function spec should be writen here
 *******************************************************************/
char * read_ini_element_value(INI *p, char *section, char *key)
{
	INI_SECTION *sect;
	INI_ELEMENT *elem;

	sect = find_ini_section(p, section);
	if(sect == NULL){
		return "";
	}

	elem = find_ini_element(sect, key);
	if(elem == NULL){
		return "";
	}

	return elem->value;
}

static int is_blank(char *line)
{
	int i;
	int r;

	for(i=0,r=1;line[i];i++){
		if(line[i] == ';' || line[i] == '\n'){
			break;
		}
		if(line[i] != ' ' && line[i] != '\t'){
			r = 0;
			break;
		}
	}

	return r;
}

static int new_section(char *line, INI *p)
{
	int i;

	INI_SECTION *sect;

	for(i=1;line[i];i++){
		if(line[i] == ']'){
			line[i] = '\0';
			break;
		}
		line[i] = toupper(line[i]);
	}
	
	if(p->num_of_sections){
		p->sections = (INI_SECTION *)realloc(p->sections, (p->num_of_sections+1)*sizeof(INI_SECTION));
	}else{
		p->sections = (INI_SECTION *)malloc(sizeof(INI_SECTION));
	}
	sect = p->sections + p->num_of_sections;
	p->num_of_sections += 1;

	sect->label = (char *)malloc(i);
	memcpy(sect->label, line+1, i);

	sect->num_of_elements = 0;
	sect->elements = NULL;

	return 1;
}

static int new_element(char *line, INI_SECTION *p)
{
	int i;

	INI_ELEMENT *elem;

	int key_length;
	int value_length;
	char quote;

	int key;
	
	quote = '\0';
	key = 0;
	key_length = 0;
	value_length = 0;
	
	for(i=0;line[i];i++){
		if(!key && line[i] == '='){
			key = 1;
			key_length = i+1;
			line[i] = '\0';
			continue;
		}

		if(key && key_length == i && !quote && (line[i] == '"' || line[i] == '\'')){
			quote = line[i];
			line[i] = '\0';
			key_length += 1;
		}else if(key && (quote == line[i] || line[i] == '\n') ){
			line[i] = '\0';
			value_length = i + 1 - key_length;
			break;
		}
	}

	if(! key_length){
		key_length = i;
		value_length = 1;
	}

	if(! value_length){
		value_length = i - key_length;
	}

	if(key_length < 2){
		return 0;
	}

	if(p->num_of_elements){
		p->elements = (INI_ELEMENT *)realloc(p->elements, (p->num_of_elements+1)*sizeof(INI_ELEMENT));
	}else{
		p->elements = (INI_ELEMENT *)malloc(sizeof(INI_ELEMENT));
	}

	elem = p->elements + p->num_of_elements;
	p->num_of_elements += 1;

	elem->key = (char *)malloc(key_length);
	for(i=0;i<key_length;i++){
        elem->key[i] = toupper(line[i]);
    }

	elem->value = (char *)malloc(value_length);
	if(value_length == 1){
		elem->value[0] = '\0';
	}else{
		memcpy(elem->value, line+key_length, value_length);
	}

	return 1;
}

static INI_SECTION *find_ini_section(INI *p, char *section)
{
	int i,n;
	char *work;

	n = strlen(section)+1;
	work = (char *)malloc(n);
	for(i=0;i<n;i++){
		work[i] = toupper(section[i]);
	}

	for(i=0;i<p->num_of_sections;i++){
		if(strcmp(work, p->sections[i].label) == 0){
			free(work);
			return p->sections + i;
		}
	}

	free(work);
	return NULL;
}

static INI_ELEMENT *find_ini_element(INI_SECTION *p, char *key)
{
	int i,n;
	char *work;

	n = strlen(key)+1;
	work = (char *)malloc(n);
	for(i=0;i<n;i++){
		work[i] = toupper(key[i]);
	}

	for(i=0;i<p->num_of_elements;i++){
		if(strcmp(work, p->elements[i].key) == 0){
			free(work);
			return p->elements + i;
		}
	}

	free(work);
	return NULL;
}
